/*
 * @(#)DMLDiagram.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.dml;

import ch.hslu.cm.*;
import ch.hslu.cm.dml.model.*;
import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
/**
 * DMLDiagram.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18  Created.
 */
public class DMLDiagram extends AbstractDiagram {
    public final static Color
    ENTITY_TYPE_CONNECTOR_COLOR = Color.black,
    ENTITY_TYPE_NAME_COMPARTMENT_COLOR = Color.white,
    ENTITY_TYPE_ATTRIBUTE_COMPARTMENT_COLOR = Color.white,
    ENTITY_TYPE_OPERATION_COMPARTMENT_COLOR = Color.white,
    ENTITY_TYPE_STROKE_COLOR = Color.black,
    ENTITY_TYPE_TEXT_COLOR = Color.black,
    ENTITY_TYPE_SHADOW_COLOR = new Color(0xbbbbbb),
    RELATION_STROKE_COLOR = new Color(0x000099),
    RELATION_FILL_COLOR = Color.white
    ;
    
    public final static int ENTITY_TYPE_LAYER = 0;
    public final static int LINK_LAYER = 1;
    
    /** Creates a new instance. */
    public DMLDiagram() {
        this(new DMLModel());
    }
    public DMLDiagram(DMLModel simulation) {
        setSimulation(simulation);
    }
    protected DiagramFigure createDiagramFigure(SimulatedElement simElem) {
        /*
        switch (simElem.getSimulatedConcept()) {
            case DMLModel.ENTITY : {
                EntityFigure f = new EntityFigure();
                f.setModel((Entity) simElem);
                return f;
            }
            case DMLModel.RELATIONSHIP : {
                RelationshipFigure f = new RelationshipFigure();
                f.setModel((Relationship) simElem);
                return f;
            }
            default :
                return null;
        }*/
        return null;
    }
}
